class Vertex {
	// attributes
	private Vertex Left =  null,
	               Right = null;
	private int Data;

	// constructors
	public Vertex() {}
	public Vertex(int Data) {
		this.Data = Data;
	}
	public Vertex(int Data, Vertex Left, Vertex Right) {
		this.Data =  Data;
		this.Left =  Left;
		this.Right = Right;
        }

	// access methods (read)
	public int    getData()  {return Data;}
	public Vertex getLeft()  {return Left;}
	public Vertex getRight() {return Right;}

	// access methods (write)
	public void setData(int Data)      {this.Data =  Data;}
	public void setLeft(Vertex Left)   {this.Left =  Left;}
	public void setRight(Vertex Right) {this.Right = Right;}

	// methods
	public String toString() {
		return (new Integer(Data).toString());
	}
}

class BinaryTree {
	// attributes
	private Vertex Root = null;

	// constructors
	public BinaryTree() {}
	public BinaryTree(Vertex Root) {this.Root = Root;}

	// access methods (read)
	public Vertex getRoot() {return Root;}

	// access methods (write)
	public void setRoot(Vertex Root) {this.Root = Root;}

	// methods
	// add a vertex using a BST algorithm
	public Vertex Add(Vertex Current, int Value) {
		if (Current == null) Current = new Vertex(Value); else {
			int curVal = Current.getData();

			if (curVal < Value)
				Current.setRight(Add(Current.getRight(), Value)); else
			if (curVal > Value)
				Current.setLeft(Add(Current.getLeft(), Value));
		}
		return Current;
	}

	public void Add(int Value) {
		Root = Add(Root, Value);
	}

	public boolean findVertex(int findValue) {
		return false;
	}

	public void inOrderPrint(Vertex Start) {
		if (Start != null) {
			inOrderPrint(Start.getLeft());
			System.out.print(Start.getData() + " | ");
			inOrderPrint(Start.getRight());
		}
	}

	public void inOrderPrint() {
		System.out.print("Inorder:\nTree = (");
		inOrderPrint(Root);
		System.out.println("\10\10\10)");
	}

	public int getSubCount(Vertex Start, int c) {
		if (Start != null) {
			int r0 = getSubCount(Start.getLeft(),  c);
			int r1 = getSubCount(Start.getRight(), c);
			return r0 + r1 + 1;
		} else return c;
	}

	public int getSubCount(Vertex Start) {
		return getSubCount(Start, 0);
	}

	public void leftRightPrint() {
		int c = getSubCount(Root),
		    i, d;
		Vertex[] Field = new Vertex[12];
		Vertex v = Root, t;

		i = 0; d = 0;
		while (i < c) {
			Field[i] = v;
			i++;
			d++; // depth

			if ((t = v.getLeft()) != null) {
				Field[i] = t;
				i++;
			}
			if ((t = v.getRight()) != null) {
				Field[i] = t;
				i++;
			}

			v = Field[i / 2 - 1];
		}

		for (i = 0; i < Field.length; i++)
			System.out.println(Field[i]);

//		System.out.println("\10\10\10)");
	}

	// prints a map of the tree
	public void printMap(Vertex Start, int Indent) {
	}

	public void printMap() {
	}
}

public class BinTree {
	// main method (program entry-point)
	public static void main(String[] args) {
		BinaryTree myTree = new BinaryTree();

		myTree.Add(16);
		myTree.Add(10);
		myTree.Add(24);
		myTree.Add(9);
		myTree.Add(14);
		myTree.Add(18);
		myTree.Add(13);
		myTree.Add(15);

		System.out.println(myTree.getSubCount(myTree.getRoot()) + " Vertices added.");

		myTree.inOrderPrint();
		myTree.leftRightPrint();
	}
}